/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.bedrock.ModelRendererWrapper;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.compat.iris.IrisCompat;
import com.tacz.guns.util.RenderHelper;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BedrockAttachmentModel
extends BedrockAnimatedModel {
    private static final String SCOPE_VIEW_NODE = "scope_view";
    private static final String SCOPE_BODY_NODE = "scope_body";
    private static final String OCULAR_RING_NODE = "ocular_ring";
    private static final String DIVISION_NODE = "division";
    private static final String OCULAR_NODE = "ocular";
    @Nullable
    protected List<BedrockPart> scopeViewPath = this.getPath((ModelRendererWrapper)this.modelMap.get("scope_view"));
    @Nullable
    protected List<BedrockPart> scopeBodyPath = this.getPath((ModelRendererWrapper)this.modelMap.get("scope_body"));
    @Nullable
    protected List<BedrockPart> ocularRingPath = this.getPath((ModelRendererWrapper)this.modelMap.get("ocular_ring"));
    @Nullable
    protected List<BedrockPart> ocularNodePath = this.getPath((ModelRendererWrapper)this.modelMap.get("ocular"));
    @Nullable
    protected List<BedrockPart> divisionNodePath = this.getPath((ModelRendererWrapper)this.modelMap.get("division"));
    private boolean isScope = true;
    private boolean isSight = false;
    private float scopeViewRadiusModifier = 1.0f;

    public BedrockAttachmentModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        if (this.divisionNodePath != null) {
            this.divisionNodePath.get((int)(this.divisionNodePath.size() - 1)).visible = false;
        }
    }

    @Nullable
    public List<BedrockPart> getScopeViewPath() {
        return this.scopeViewPath;
    }

    public void setIsScope(boolean isScope) {
        if (isScope) {
            this.isSight = false;
        }
        this.isScope = isScope;
    }

    public void setIsSight(boolean isSight) {
        if (isSight) {
            this.isScope = false;
        }
        this.isSight = isSight;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public boolean isSight() {
        return this.isSight;
    }

    public void setScopeViewRadiusModifier(float scopeViewRadiusModifier) {
        this.scopeViewRadiusModifier = scopeViewRadiusModifier;
    }

    @Override
    public void render(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        if (transformType.method_29998()) {
            if (this.isScope) {
                this.renderScope(matrixStack, transformType, renderType, light, overlay);
            } else if (this.isSight) {
                this.renderSight(matrixStack, transformType, renderType, light, overlay);
            }
        } else {
            if (this.scopeBodyPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
            }
            if (this.ocularRingPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
            }
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private void renderSight(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        if (this.ocularNodePath != null) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.clearStencil((int)0);
            RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
            RenderSystem.stencilMask((int)255);
            RenderSystem.stencilFunc((int)519, (int)1, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (this.divisionNodePath != null) {
            RenderSystem.stencilFunc((int)514, (int)1, (int)255);
            RenderSystem.disableDepthTest();
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePath);
            RenderSystem.enableDepthTest();
        }
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        if (this.scopeBodyPath != null) {
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private Vector3f getBedrockPartCenter(class_4587 poseStack, @NotNull List<BedrockPart> path) {
        poseStack.method_22903();
        for (BedrockPart part : path) {
            part.translateAndRotateAndScale(poseStack);
        }
        Vector3f result = new Vector3f(poseStack.method_23760().method_23761().m30(), poseStack.method_23760().method_23761().m31(), poseStack.method_23760().method_23761().m32());
        poseStack.method_22909();
        return result;
    }

    private void renderTempPart(class_4587 poseStack, class_811 transformType, class_1921 renderType, int light, int overlay, @NotNull List<BedrockPart> path) {
        poseStack.method_22903();
        for (int i = 0; i < path.size() - 1; ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        BedrockPart part = path.get(path.size() - 1);
        part.visible = true;
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
        part.render(poseStack, transformType, vertexConsumer, light, overlay);
        if (!IrisCompat.endBatch(bufferSource)) {
            bufferSource.method_22994(renderType);
        }
        part.visible = false;
        poseStack.method_22909();
    }

    private void renderScope(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        if (this.ocularRingPath != null) {
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
        }
        if (this.ocularNodePath != null) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.stencilMask((int)255);
            RenderSystem.stencilFunc((int)519, (int)1, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (this.scopeBodyPath != null) {
            RenderSystem.stencilFunc((int)517, (int)1, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        class_287 builder = class_289.method_1348().method_1349();
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7682);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        Vector3f ocularCenter = this.getBedrockPartCenter(matrixStack, this.ocularNodePath);
        float centerX = ocularCenter.x() * 16.0f * 90.0f;
        float centerY = ocularCenter.y() * 16.0f * 90.0f;
        float rad = 80.0f * this.scopeViewRadiusModifier;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            rad *= IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(class_310.method_1551().method_1488());
        }
        builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        builder.method_22912((double)centerX, (double)centerY, -90.0).method_1336(255, 255, 255, 255).method_1344();
        for (int i = 0; i <= 90; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 90.0f;
            float sin = class_3532.method_15374((float)angle);
            float cos = class_3532.method_15362((float)angle);
            builder.method_22912((double)(centerX + cos * rad), (double)(centerY + sin * rad), -90.0).method_1336(255, 255, 255, 255).method_1344();
        }
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
        if (this.divisionNodePath != null) {
            RenderSystem.stencilFunc((int)514, (int)2, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePath);
        }
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        super.render(matrixStack, transformType, renderType, light, overlay);
    }
}

